<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SaaSServiceManagement;

class Release extends \Google\Collection
{
  protected $collection_key = 'outputVariables';
  /**
   * @var string[]
   */
  public $annotations;
  protected $blueprintType = Blueprint::class;
  protected $blueprintDataType = '';
  /**
   * @var string
   */
  public $createTime;
  /**
   * @var string
   */
  public $etag;
  protected $inputVariableDefaultsType = UnitVariable::class;
  protected $inputVariableDefaultsDataType = 'array';
  protected $inputVariablesType = UnitVariable::class;
  protected $inputVariablesDataType = 'array';
  /**
   * @var string[]
   */
  public $labels;
  /**
   * @var string
   */
  public $name;
  protected $outputVariablesType = UnitVariable::class;
  protected $outputVariablesDataType = 'array';
  protected $releaseRequirementsType = ReleaseRequirements::class;
  protected $releaseRequirementsDataType = '';
  /**
   * @var string
   */
  public $uid;
  /**
   * @var string
   */
  public $unitKind;
  /**
   * @var string
   */
  public $updateTime;

  /**
   * @param string[]
   */
  public function setAnnotations($annotations)
  {
    $this->annotations = $annotations;
  }
  /**
   * @return string[]
   */
  public function getAnnotations()
  {
    return $this->annotations;
  }
  /**
   * @param Blueprint
   */
  public function setBlueprint(Blueprint $blueprint)
  {
    $this->blueprint = $blueprint;
  }
  /**
   * @return Blueprint
   */
  public function getBlueprint()
  {
    return $this->blueprint;
  }
  /**
   * @param string
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * @param string
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * @param UnitVariable[]
   */
  public function setInputVariableDefaults($inputVariableDefaults)
  {
    $this->inputVariableDefaults = $inputVariableDefaults;
  }
  /**
   * @return UnitVariable[]
   */
  public function getInputVariableDefaults()
  {
    return $this->inputVariableDefaults;
  }
  /**
   * @param UnitVariable[]
   */
  public function setInputVariables($inputVariables)
  {
    $this->inputVariables = $inputVariables;
  }
  /**
   * @return UnitVariable[]
   */
  public function getInputVariables()
  {
    return $this->inputVariables;
  }
  /**
   * @param string[]
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param UnitVariable[]
   */
  public function setOutputVariables($outputVariables)
  {
    $this->outputVariables = $outputVariables;
  }
  /**
   * @return UnitVariable[]
   */
  public function getOutputVariables()
  {
    return $this->outputVariables;
  }
  /**
   * @param ReleaseRequirements
   */
  public function setReleaseRequirements(ReleaseRequirements $releaseRequirements)
  {
    $this->releaseRequirements = $releaseRequirements;
  }
  /**
   * @return ReleaseRequirements
   */
  public function getReleaseRequirements()
  {
    return $this->releaseRequirements;
  }
  /**
   * @param string
   */
  public function setUid($uid)
  {
    $this->uid = $uid;
  }
  /**
   * @return string
   */
  public function getUid()
  {
    return $this->uid;
  }
  /**
   * @param string
   */
  public function setUnitKind($unitKind)
  {
    $this->unitKind = $unitKind;
  }
  /**
   * @return string
   */
  public function getUnitKind()
  {
    return $this->unitKind;
  }
  /**
   * @param string
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Release::class, 'Google_Service_SaaSServiceManagement_Release');
