<?php

/**
 * This code was generated by
 * ___ _ _ _ _ _    _ ____    ____ ____ _    ____ ____ _  _ ____ ____ ____ ___ __   __
 *  |  | | | | |    | |  | __ |  | |__| | __ | __ |___ |\ | |___ |__/ |__|  | |  | |__/
 *  |  |_|_| | |___ | |__|    |__| |  | |    |__] |___ | \| |___ |  \ |  |  | |__| |  \
 *
 * Twilio - Intelligence
 * This is the public Twilio REST API.
 *
 * NOTE: This class is auto generated by OpenAPI Generator.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


namespace Twilio\Rest\Intelligence\V2\Transcript;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;


/**
 * @property string[]|null $locations
 * @property string|null $transcriptSid
 * @property string|null $url
 */
class EncryptedOperatorResultsInstance extends InstanceResource
{
    /**
     * Initialize the EncryptedOperatorResultsInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $transcriptSid The unique SID identifier of the Transcript.
     */
    public function __construct(Version $version, array $payload, string $transcriptSid)
    {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'locations' => Values::array_get($payload, 'locations'),
            'transcriptSid' => Values::array_get($payload, 'transcript_sid'),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = ['transcriptSid' => $transcriptSid, ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return EncryptedOperatorResultsContext Context for this EncryptedOperatorResultsInstance
     */
    protected function proxy(): EncryptedOperatorResultsContext
    {
        if (!$this->context) {
            $this->context = new EncryptedOperatorResultsContext(
                $this->version,
                $this->solution['transcriptSid']
            );
        }

        return $this->context;
    }

    /**
     * Fetch the EncryptedOperatorResultsInstance
     *
     * @param array|Options $options Optional Arguments
     * @return EncryptedOperatorResultsInstance Fetched EncryptedOperatorResultsInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(array $options = []): EncryptedOperatorResultsInstance
    {

        return $this->proxy()->fetch($options);
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name)
    {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string
    {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Intelligence.V2.EncryptedOperatorResultsInstance ' . \implode(' ', $context) . ']';
    }
}

